<!DOCTYPE html>
<html>
<head>
    <title>Student Admission Form</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-100 p-10">

<div class="max-w-4xl mx-auto bg-white p-10 rounded-xl shadow-lg">
    <h1 class="text-3xl font-bold mb-6 text-center">Student Admission Form</h1>

    <form action="submit.php" method="POST" enctype="multipart/form-data">

        <!-- Student Name -->
        <label class="font-semibold">Student Full Name *</label>
        <input name="full_name" required class="w-full border p-2 rounded mb-4">

        <!-- Photo -->
        <label class="font-semibold">Student Photo *</label>
        <input type="file" name="photo" required class="w-full mb-4" accept="image/*">

        <!-- DOB -->
        <label class="font-semibold">Date of Birth *</label>
        <input type="date" name="dob" required class="w-full border p-2 rounded mb-4">

        <!-- Gender -->
        <label class="font-semibold">Gender *</label>
        <select name="gender" required class="w-full border p-2 rounded mb-4">
            <option value="">Select Gender</option>
            <option value="Male">Male</option>
            <option value="Female">Female</option>
        </select>

        <!-- Birth Certificate -->
        <label class="font-semibold">Birth Certificate Number</label>
        <input name="birth_cert" class="w-full border p-2 rounded mb-4">

        <!-- Class -->
        <label class="font-semibold">Class (যে ক্লাসে ভর্তি হবে) *</label>
        <select name="class_name" required class="w-full border p-2 rounded mb-4">
            <option value="">Select Class</option>
            <option value="Play">Play</option>
            <option value="Nursery">Nursery</option>
            <option value="KG">KG</option>
            <option value="One">Class One</option>
            <option value="Two">Class Two</option>
        </select>

        <h2 class="text-xl font-bold mt-6 mb-3">Present Address</h2>

        <!-- Present Address -->
        <label class="font-semibold">Present Address *</label>
        <textarea name="address_present" required class="w-full border p-2 rounded mb-4"></textarea>

        <!-- Present District -->
        <label class="font-semibold">Present District *</label>
        <input name="present_district" required class="w-full border p-2 rounded mb-4">

        <!-- Present Post Code -->
        <label class="font-semibold">Present Post Code</label>
        <input name="present_post_code" class="w-full border p-2 rounded mb-4">

        <h2 class="text-xl font-bold mt-6 mb-3">Permanent Address</h2>

        <!-- Permanent Address -->
        <label class="font-semibold">Permanent Address</label>
        <textarea name="address_permanent" class="w-full border p-2 rounded mb-4"></textarea>

        <h2 class="text-xl font-bold mt-6 mb-3">Parents Information</h2>

        <!-- Father info -->
        <label class="font-semibold">Father's Name *</label>
        <input name="father_name" required class="w-full border p-2 rounded mb-4">

        <label class="font-semibold">Father's NID</label>
        <input name="father_nid" class="w-full border p-2 rounded mb-4">

        <label class="font-semibold">Father's Phone Number *</label>
        <input name="father_phone" required class="w-full border p-2 rounded mb-4">

        <!-- Mother info -->
        <label class="font-semibold">Mother's Name *</label>
        <input name="mother_name" required class="w-full border p-2 rounded mb-4">

        <label class="font-semibold">Mother's NID</label>
        <input name="mother_nid" class="w-full border p-2 rounded mb-4">

        <!-- Previous School -->
        <label class="font-semibold">Previous School (যদি থাকে)</label>
        <input name="previous_school" class="w-full border p-2 rounded mb-4">

        <!-- Health -->
        <label class="font-semibold">Health Information</label>
        <textarea name="health_info" class="w-full border p-2 rounded mb-4" placeholder="Any health issues or allergies..."></textarea>

        <!-- Special Note -->
        <label class="font-semibold">Special Note</label>
        <textarea name="note" class="w-full border p-2 rounded mb-4" placeholder="Any additional information..."></textarea>

        <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white py-3 rounded-lg font-bold transition duration-200">
            Submit Admission Form
        </button>
    </form>
</div>

</body>
</html>
