<?php
include "db.php";

$students = mysqli_fetch_assoc(mysqli_query($conn, "SELECT count(*) AS total FROM students"))['total'];
$class_count = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(DISTINCT class_name) as classes FROM students"))['classes'];
?>

<!DOCTYPE html>
<html>
<head>
<script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="p-10 bg-gray-100">

<h1 class="text-3xl font-bold mb-6">Admin Dashboard</h1>

<div class="grid grid-cols-3 gap-4 mb-10">
    <div class="bg-white p-6 shadow rounded">
        <h2 class="text-xl font-bold">Total Students</h2>
        <p class="text-3xl mt-2 text-blue-600"><?= $students ?></p>
    </div>
    <div class="bg-white p-6 shadow rounded">
        <h2 class="text-xl font-bold">Total Classes</h2>
        <p class="text-3xl mt-2 text-green-600"><?= $class_count ?></p>
    </div>
    <div class="bg-white p-6 shadow rounded">
        <h2 class="text-xl font-bold">Quick Actions</h2>
        <div class="mt-3 space-y-2">
            <a href="list.php" class="block bg-blue-600 text-white py-2 px-4 rounded text-center hover:bg-blue-700">
                View All Students
            </a>
        </div>
    </div>
</div>

</body>
</html>
